//File: main.cpp

//Note: SDL.h needs to be included before
//the main function, because SDL.h has a macro
//that redefines the main function.
#define SDL_MAIN_HANDLED //Disable the SDL_Main macro.
#include <SDL2/SDL.h> //for SDL_Quit

//Including OpenGL.
#include <SDL2/SDL_opengl.h>
#include <GL/glu.h>

//For hiding the console window.
#include <Windows.h>

#include <string>
#include <iostream>
using std::string;
using std::cout;
using std::endl;

//-----------------------------------------------
//
//               EXITING THE PROGRAM
//
//-----------------------------------------------

void PoliteExit() {
    cout << "Exiting program from PoliteExit.\n";
    //Might want to do more here.
    exit(0);
}

//-----------------------------------------------
//
//                     INIT SDL
//
//-----------------------------------------------

//The SDL 2.0 way.
SDL_Window * Helper_SDL_Init() {
    string caption = "SDL2 Hello World";

    //Initializing SDL itself:
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER | SDL_INIT_AUDIO) == -1) {
        cout << "Error: Could not initialize SDL2" << endl;
        PoliteExit();
    }

    //Setting the bit width of the OpenGL depth buffer.
    //Should this be before or after SDL_CreateWindow?
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);

    SDL_Window * window = 0;

    //Using the option SDL_WINDOW_FULLSCREEN_DESKTOP
    //is perhaps not necessary.  However a good thing about
    //using it is we do not have to ask windows for the
    //desktop resolution.
    Uint32 flags =
        SDL_WINDOW_OPENGL |
        SDL_WINDOW_FULLSCREEN_DESKTOP;
    window = SDL_CreateWindow(
        caption.c_str(),
        SDL_WINDOWPOS_UNDEFINED,
        SDL_WINDOWPOS_UNDEFINED,
        0, 0, flags);

    if( window == 0 ) {
        cout << "Error: SDL_CreateWindow failed." << endl;
        cout << "Try setting the screen width and height to that"
            " of your desktop" << endl;
        PoliteExit();
    }

    //Setting the window title.
    SDL_SetWindowTitle(window, caption.c_str());

    //Creating the open GL context.
    //Do I need to do anything with this?
    //SDL_GLContext glcontext =
    SDL_GL_CreateContext(window);

    //So mouse does not have min and max x and y values.
    //SDL_ShowCursor(SDL_DISABLE);
    SDL_SetRelativeMouseMode(SDL_TRUE);

    return window;
}

//-----------------------------------------------
//
//                PROCESS INPUT
//
//-----------------------------------------------

void Helper_ProcessInput() {
    SDL_Event e;
    while (SDL_PollEvent(&e)) {
        if( e.type == SDL_KEYDOWN &&
            e.key.keysym.sym == SDLK_ESCAPE )
        {
            cout << "Exiting program because escape key pressed.\n";
            PoliteExit();
        }
    }
}

//-----------------------------------------------
//
//                   RENDERING
//
//-----------------------------------------------

void Helper_Render(
    SDL_Window * sdl_window)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    //
    //Drawing a green triangle in the upper
    //right and corner of the screen.
    glBegin(GL_TRIANGLES);
    glColor3f(0.2, 0.7, 0.5);
    glVertex3f(0, 0, 0);
    glVertex3f(1, 0, 0);
    glVertex3f(0, 1, 0);
    glEnd();
    //
    SDL_GL_SwapWindow(sdl_window);
}

//-----------------------------------------------
//
//                MAIN FUNCTION
//
//-----------------------------------------------

int main(int argc, char ** argv) {
    //Hiding the console window.
    HWND windowHandle = GetConsoleWindow();
    ShowWindow(windowHandle,SW_HIDE);

    //Maping stdout to a file.
    std::freopen("../../stdout.txt", "w", stdout);
    
    cout << "SDL2 Hello world!\n";
    cout << "Here in main function.\n";

    //Needed because #defined SDL_MAIN_HANDLED.
    //See https://wiki.libsdl.org/SDL_SetMainReady
    SDL_SetMainReady();

    //Making it so SDL_Quit is called
    //the program exits.
    //Important, because otherwise output
    //to stdout.txt may (sometimes) not appear:
    atexit(SDL_Quit);

    //Initializing SDL.
    SDL_Window * sdl_window = Helper_SDL_Init();
    if( !sdl_window ) {
        cout << "*** Error: std_window is null.\n";
        PoliteExit();
    }

    while(true) {
        Helper_ProcessInput();
        Helper_Render(sdl_window);
    }

    //This line is so there are
    //no compiler warnings.
    return 0;
}
