--This file describes the various "get_" functions.

-------------------------------------------------
--       Rendering, Geometry, and Motion
-------------------------------------------------

function p.get_radius() return 0.1 end
function p.get_collides() return true end
function p.get_solid_wrt_player() return false end

-------------------------------------------------
--              Damage AND Health
-------------------------------------------------

function p.get_getting_hit_type() return "" end
function p.get_hitting_type() return "" end

function p.get_health() return 10 end

-------------------------------------------------
--                   Shooting
-------------------------------------------------

function p.get_shoots() return false end

-------------------------------------------------
--                   Sound
-------------------------------------------------

-------------------------------------------------
--              Identity String
-------------------------------------------------

-- If not defined, then false.
function p.get_identifies() return false end

-------------------------------------------------
--            Type Init Function
-------------------------------------------------

function p.__type_init(id)
    ia_ment_set_builtin_var_f(id, "__ttl", 60.0)
    ia_ment_set_builtin_var_f(id, "__radius", 0.1)
    ia_ment_set_builtin_var_s(id, "__mesh", "sphere_pink")
end

-------------------------------------------------
--         Movement Hitting Callbacks
-------------------------------------------------

function p.__on_block_hit(
    inst_id,
    level, bp, lp,
    normal_side, normal)

    --CHANGE THIS!!!

    --Converting to block coords.
    -- vcp = ga_chunk_id_to_vcp(chunk_id)
    -- lbp = std.bp(pos_x, pos_y, pos_z)
    -- bp = std.lbp_to_bp(vcp, lbp)
    -- level = ga_chunk_id_to_level(chunk_id);
    
    --ga_print(bp.x .. " " .. bp.y .. " " .. bp.z)

    bt = ""

    --Calculating the adjacent position.
    adj_bp = {}
    adj_bp.x = bp.x
    adj_bp.y = bp.y
    adj_bp.z = bp.z
    if normal_side == 0 then
        adj_bp.x = adj_bp.x + 1
        bt = "block_ladder_x_neg"
    end
    if normal_side == 1 then
        adj_bp.x = adj_bp.x - 1
        bt = "block_ladder_x_pos"
    end
    if normal_side == 2 then
        adj_bp.y = adj_bp.y + 1
        bt = "block_ladder_y_neg"
    end
    if normal_side == 3 then
        adj_bp.y = adj_bp.y - 1
        bt = "block_ladder_y_pos"
    end
    if normal_side == 4 then
        adj_bp.z = adj_bp.z + 1
        bt = ""
    end
    if normal_side == 5 then
        adj_bp.z = adj_bp.z - 1
        bt = ""
    end

    --Adding the block.
    if bt ~= "" then
        ga_block_change_rl(level, adj_bp, bt, 10.0)
    end

    return true
end

