function p.__load_game()
    --Adding windows to the hud.
    ga_hud_window_add("win_hud", 0)
end

--This is called before the metachunk tree update,
--before the proximity update, and before the
--discrete updates (if there are any of those).
function p.__update()
    --Using inventory iterms, weapons, etc.
    game_inv_exec.update()

    --Death checking.
    -- if ga_get_i("xar.player.health.amount") < 0 then
    --     ga_print("health is negative in top.update")
    --     if ga_get_sys_b("game.player.alive") then
    --         ga_kill_player()
    --     end
    -- end
    --Opening the death window.
    if not ga_get_sys_b("game.player.alive") then
        ga_hud_window_add("win_death", 1000)
    end
end

function p.__update_passive()
    --Nothing to do.
end

function p.__update_discrete_pre()
    game_init_body.first_try()

    --In the proximity update function,
    --if the player is close enough to a ladder block,
    --that blocks's on_touch function will be called.
    --The function can then set the movement mode to
    --"ladder_x_pos", or whatever, if appropriate.
    ga_set_s("var.movement.mod", "normal")

    --more?
end

function p.__update_discrete_post()
    game_init_body.first_try()

    game_movement.update_discrete()
    --more?
end

function p.__game_input(str)
    if (str == "help") then
        ga_console_print("Strings that can be passed to game_input:")
        ga_console_print("\n")
        ga_console_print("move XXX")
        ga_console_print("equip_from_screen_inv XXX")
        ga_console_print("equiv_from_screen_inv_right")
        ga_console_print("equiv_from_screen_inv_left")
        ga_console_print("use_equipped primary start")
        ga_console_print("use_equipped primary stop")
        ga_console_print("use_equipped secondary start")
        ga_console_print("use_equipped secondary stop")
        ga_console_print("fly")
        ga_console_print("fly on")
        ga_console_print("fly off")
        return ""
    end

    if( str == "__game_saved__" ) then
        game_msg.add("Game saved")
        return ""
    end

    if( str:find("^__spiral_of_death__") ~= nil ) then
        return ""
    end

    if( str == "__screenshot__" ) then
        game_msg.add("Screenshot saved")
        return ""
    end

    --Moving.
    --Checking if str starts with "move".
    if( str:find("^move") ~= nil ) then
        --str starts with "move".
        game_movement.input(str)
        return ""
    end

    --Equipping an item using 0-9.
    for i = 0,9 do
        if (str == "equip_from_screen_inv " .. tostring(i)) then
            ga_set_i("var.player.cur_wep", i)
            game_inv_exec.end_use()
            return ""
        end
    end

    --Equipping an item using the mouse wheel.
    if( str == "equiv_from_screen_inv_right" ) then
        local i = ga_get_i("var.player.cur_wep")
        i = i + 1
        while( i < 0 ) do i = i + 10 end
        i = (i % 10)
        ga_set_i("var.player.cur_wep", i)
        return ""
    elseif( str == "equiv_from_screen_inv_left" ) then
        local i = ga_get_i("var.player.cur_wep")
        i = i - 1
        while( i < 0 ) do i = i + 10 end
        i = (i % 10)
        ga_set_i("var.player.cur_wep", i)
        return ""
    end

    --Using the equipped item.
    if (str == "use_equipped primary start") then
        gun = ga_get_i("var.player.cur_wep")
        game_inv_exec.start_use(gun, true)
        return ""
    end
    if (str == "use_equipped primary stop") then
        game_inv_exec.end_use()
        return ""
    end
    if (str == "use_equipped secondary start") then
        gun = ga_get_i("var.player.cur_wep")
        game_inv_exec.start_use(gun, false)
        return ""
    end
    if (str == "use_equipped secondary stop") then
        game_inv_exec.end_use()
        return ""
    end
    if( str == "fly" ) then
        cur_mode = ga_get_sys_s("game.player.move.mode")
        if( cur_mode ~= "fly" ) then
            game_init_body.fly_try()
        end
        if( cur_mode ~= "ground" ) then
            game_init_body.ground_try()
        end
        return ""
    end
    if( str == "fly on" ) then
        cur_mode = ga_get_sys_s("game.player.move.mode")
        if( cur_mode ~= "fly" ) then
            game_init_body.fly_try()
        end
        return ""
    end
    if( str == "fly off" ) then
        cur_mode = ga_get_sys_s("game.player.move.mode")
        if( cur_mode ~= "ground" ) then
            game_init_body.ground_try()
        end
        return ""
    end

    if( str == "debug1" ) then
        --You can put debugging code here.
        return ""
    end

    ga_console_print("^1Error: unknown string passed to game_input: ")
    ga_console_print(str)
    return ""
end

-- function p.screen_inv_selected()
--     return ga_get_i("game.player.cur_wep")
-- end

function p.__killed_player()
    ga_print("top.__killed_player")
    --Nothing to do.
    ga_play_sound_menu("player_death")
end

function p.__respawn_player()
    ga_print("top.__respawn_player")
    --Nothing to do.
end
