function p.start_use(gun, primary)
    ga_set_i("var.inv_exec.cur_wep", gun)
    ga_set_b("var.inv_exec.primary", primary)
    ga_set_b("var.inv_exec.starting_shoot", true)
end

function p.end_use()
    ga_set_i("var.inv_exec.cur_wep", -1)
end

function p.update()
    if ga_get_b("var.inv_exec.starting_shoot") then
        p.try_shoot()
        ga_set_b("var.inv_exec.starting_shoot", false)
    end
end

function p.try_shoot()
    local cur_gun = ga_get_i("var.inv_exec.cur_wep")
    local primary = ga_get_b("var.inv_exec.primary")

    local viewer_chunk_id = ga_get_viewer_chunk_id()
    local viewer_level = ga_chunk_id_to_level(viewer_chunk_id)
    local viewer_pos = ga_get_viewer_offset()
    local look = ga_get_sys_v("game.player.camera.look")

    if cur_gun == 1 then
        --Block gun.
        local ent_type = (primary and
            "ment_block_gun_add" or "ment_block_gun_remove")

        local extend_len = 0.1
        local pos = std.vec_add(viewer_pos, std.vec_scale(look, extend_len))

        ga_ment_start(viewer_level, pos, ent_type)

        local speed = 30.0
        local vel = std.vec_scale(look, speed)
        ga_ment_init_set_v("__vel", vel)

        ga_ment_end()
    end
    if cur_gun == 2 then
        --Glass block gun.
        local ent_type = (primary and
            "ment_block_glass_gun_add" or "ment_block_gun_remove")

        local extend_len = 0.1
        local pos = std.vec_add(viewer_pos, std.vec_scale(look, extend_len))

        ga_ment_start(viewer_level, pos, ent_type)

        local speed = 30.0
        local vel = std.vec_scale(look, speed)
        ga_ment_init_set_v("__vel", vel)

        ga_ment_end()
    end
end
