-- This is a little ugly:
-- Changing the player's body dimension is accomplished
-- by calling the function ga_move_set_body_ground.
-- However, that function can fail (in the player is
-- colliding with world geometry).  So, to initialize the
-- player's body dimension when the player starts a new game,
-- the function ga_move_set_body_ground needs to be called
-- every cycle until it succeeds.  Until then, then default
-- body dimensions will be used (and the default involves
-- fly mode, not ground mode).  So, when making a game,
-- it would be smart to have the player starting in the middle
-- of a room, not on the ground).
function p.first_try()
    if ga_get_b("var.init.body") then return end
    local worked = p.ground_try()
    if( worked ) then
        ga_set_b("var.init.body", true)
    end
end

function p.ground_try()
    local tele = std.vec_zero()
    local new_radius     = ga_get_f("var.body.normal.radius")
    local new_bot_to_eye = ga_get_f("var.body.normal.bot_to_eye")
    local new_eye_to_top = ga_get_f("var.body.normal.eye_to_top")
    return ga_move_set_body_ground(
        tele, new_radius,
        new_bot_to_eye, new_eye_to_top)
end

function p.fly_try()
    local tele = std.vec_zero()
    local new_radius = 0.3
    local use_true_up = true
    return ga_move_set_body_fly(
        tele, new_radius, use_true_up)
end
