function p.__render(wid)
    ga_win_set_background(wid, std.vec(0.0, 0.0, 0.0), 1.0)

    ga_win_set_char_size(wid, 0.03, 0.06)
    ga_win_txt_center(wid, 0.92, "SELECT TOOL")

    local min_y = 0.3
    local max_y = 0.6
    local char_w = 0.02
    local char_h = 0.04
    local col = {x=0.0, y=0.5, z=0.5}
    local options = {
        "CLEAR CHUNK",
        "SINGLE BLOCK",
        "BLOCK LINE",
        "PAINT CAN",
        "PAINT CAN XY"}
    ga_win_widget_small_list_start(
        wid, min_y, max_y, char_w, char_h,
        col, options)

    ga_win_set_char_size(wid, 0.02, 0.04)
    ga_win_txt_center(wid, 0.06, "Go Back (ESC)")
end

function p.__process_input(wid)
    if ga_win_key_pressed(wid, "ESC") then
        ga_window_pop()
        return
    end

    local sel_num = ga_win_widget_small_list_process_input(wid)
    if( sel_num >= 0 ) then
        local sel_str = ga_win_widget_small_list_get_entry(wid, sel_num)
        if( sel_str == "CLEAR CHUNK" ) then
            game_xce_tool_helpers.set_cur_tool_name("clear")
            ga_window_pop_all()
            return
        end
        if( sel_str == "SINGLE BLOCK" ) then
            game_xce_tool_helpers.set_cur_tool_name("single_block")
            ga_window_pop_all()
            return
        end
        if( sel_str == "BLOCK LINE" ) then
            game_xce_tool_helpers.set_cur_tool_name("block_line")
            ga_window_pop_all()
            return
        end
        if( sel_str == "PAINT CAN" ) then
            game_xce_tool_helpers.set_cur_tool_name("paintcan")
            ga_window_pop_all()
            return
        end
        if( sel_str == "PAINT CAN XY" ) then
            game_xce_tool_helpers.set_cur_tool_name("paintcan_xy")
            ga_window_pop_all()
            return
        end
    end
end
