local initialized = false
local blocks_array = {}
local cur_search_str = ""

function p.init_maybe(wid)
    if( initialized ) then return end
    initialized = true

    ga_print("win_xce_tool_select_block_xar")

    --Getting all block types that start with "XAR_".
    blocks_array = ga_get_block_names_with_prefix("XAR_")

    local min_y = 0.9
    local w = 0.01
    local h = 0.02
    ga_win_widget_text_input_start(wid, min_y, w, h)

    p.refresh_options(wid)
end

--For each string str2 in strs,
--makes sure that stre2 is a substring of str.
function p.matches(str, components)
    for _,v in ipairs(components) do
        if not string.find(str, v) then
            return false
        end
    end
    return true
end

function p.refresh_options(wid)
    local cur_search_str_upper = string.upper(cur_search_str)
    local components = game_xce_string.split(cur_search_str_upper)

    local min_y = 0.15
    local max_y = 0.80
    local char_w = 0.015
    local char_h = 0.03
    local col = {x=0.0, y=0.5, z=0.5}
    --
    local options = {}
    local i = 1
    for k,v in ipairs(blocks_array) do
        local name = v.name
        if p.matches(name, components) then
            options[i] = name
            i = i + 1
        end
    end
    --
    local num_lines = 15
    ga_win_widget_large_list_start(
        wid, min_y, max_y, char_w, char_h,
        col, num_lines, options)

    ga_win_widget_text_input_set_enable_enter(wid, false)
end

function p.__render(wid)
    p.init_maybe(wid)

    ga_win_set_background(wid, std.vec(0.0, 0.0, 0.0), 1.0)

    ga_win_set_char_size(wid, 0.03, 0.06)
    ga_win_txt_center(wid, 0.92, "SELECTING A XAR BLOCK TYPE")

    ga_win_set_char_size(wid, 0.02, 0.04)
    ga_win_txt_center(wid, 0.06, "Go Back (ESC)")
end

function p.__process_input(wid)
    if ga_win_key_pressed(wid, "ESC") then
        ga_window_pop()
        return
    end

    --Search string.
    ga_win_widget_text_input_process_input(wid)
    local new_search_str = ga_win_widget_text_input_get_text(wid)
    if( new_search_str ~= cur_search_str ) then
        cur_search_str = new_search_str
        p.refresh_options(wid)
    end

    --Large list.
    local sel_num = ga_win_widget_large_list_process_input(wid) --0 indexed.
    if( sel_num >= 0 ) then
        local sel_str = ga_win_widget_large_list_get_entry(wid, sel_num)
        game_xce_tool_helpers.set_cur_bt(sel_str)
        ga_window_pop_all()
        return
    end
end
