-------------------------------------------------
--            Type Init Function
-------------------------------------------------

function p.__type_init(id)
    ia_ment_set_builtin_var_f(id, "__ttl", 60.0)
    ia_ment_set_builtin_var_f(id, "__radius", 0.1)
    ia_ment_set_builtin_var_s(id, "__mesh", "sphere_pink")
end

-------------------------------------------------
--         Movement Hitting Callbacks
-------------------------------------------------

--This functions returns true to signify that
--the projectile should stop moving.
function p.__on_block_hit(
    inst_id,
    level, bp, lp,
    normal_side, normal)
--
    local start_bp = bp

    local replace_bt = game_xce_tool_helpers.get_cur_bt()
    local vcp = ga_bp_to_parent_vcp(bp)

    --To do: add a helper function for turing a
    --direction int into a "unit" block like this.
    local side = std.opp_side(normal_side)
    local tan_add = game_xce_math.side_to_unit_block(side)
    --tan_side is a length one block, like (0,-1,0) for example.

    local start_bt = ga_block_get(level, start_bp)

    for i = 0,15 do
        local bp2 = std.bp(
            start_bp.x + i*tan_add.x,
            start_bp.y + i*tan_add.y,
            start_bp.z + i*tan_add.z)
        local vcp2 = ga_bp_to_parent_vcp(bp2)
        if not std.bp_eq(vcp, vcp2) then break end
        local bt2 = ga_block_get(level, bp2)
        if( bt2 ~= start_bt ) then break end
        -- if not ga_bt_get_physically_solid(bt2) then break end
        ga_block_change_perm(level, bp2, replace_bt)
    end

    --Terminal hit.
    return true
end
