function p.__load_game()
    --Adding windows to the hud.
    ga_hud_window_add("win_hud", 0)
end

--This is called before the metachunk tree update,
--before the proximity update, and before the
--discrete updates (if there are any of those).
function p.__update()
    --Using inventory iterms, weapons, etc.
    game_xce_inv_exec.update()

    --Death checking.
    if not ga_get_sys_b("game.player.alive") then
        ga_print("pushing death window")
        ga_hud_window_add("win_death", 200)
    end

    --Maybe put the call to game_inv_regen.perform_update back in.
end

function p.__update_passive()
    --Nothing to do.
end

function p.__update_discrete_pre()
    game_xce_init_body.first_try()
end

function p.__update_discrete_post()
    game_xce_init_body.first_try()

    game_xce_movement.update_discrete()

    game_xce_inv_exec.update()
end

function p.__game_input(str)
    --New code.
    local split = game_str.split_into_head_and_tail(str)
    local cmd_name = split.head
    local cmd_options = split.tail
    if( game_command_system.command_exists(cmd_name) ) then
        -- ga_print("About to call xar command system: " .. str)
        local result_str = game_command_system.run_command(cmd_name, cmd_options)
        -- ga_print("Returning string from top.game_input: " .. result_str)
        return result_str
    end

    if( str == "__game_saved__" ) then
        game_msg.add("Game saved")
        return ""
    end

    if( str:find("^__spiral_of_death__") ~= nil ) then
        return ""
    end

    if( str == "__screenshot__" ) then
        game_msg.add("Screenshot saved")
        return ""
    end

    --Equipping an item using 0-9.
    for i = 0,9 do
        if (str == "equip_from_screen_inv " .. tostring(i)) then
            ga_set_i("var.player.cur_wep", i)
            game_inv_exec.end_use()
            return ""
        end
    end

    --Using the equipped item.
    if (str == "use_equipped primary start") then
        gun = ga_get_i("var.player.cur_wep")
        game_inv_exec.start_use(gun, true)
        return ""
    end
    if (str == "use_equipped primary stop") then
        game_inv_exec.end_use()
        return ""
    end
    if (str == "use_equipped secondary start") then
        gun = ga_get_i("var.player.cur_wep")
        game_inv_exec.start_use(gun, false)
        return ""
    end
    if (str == "use_equipped secondary stop") then
        game_inv_exec.end_use()
        return ""
    end
    
    ga_console_print("^1Error: unknown string passed to game_input: ")
    ga_console_print(str)
    return ""
end

function p.__game_input_get_all_cmds()
    return game_command_system.get_commands_in_single_str()
end

function p.__game_input_get_help_str(cmd_name)
    return game_command_system.get_help(cmd_name)
end

function p.__killed_player()
    ga_print("top.__killed_player")
    --Nothing to do.
    -- ga_play_sound_menu("player_death")
end

function p.__respawn_player()
    ga_print("top.__respawn_player")
    ga_hud_window_remove("win_death")
end
