function p.get_cur_wep()
    return ga_get_i("xce.item.cur_item")
end

function p.get_tool_tex(i)
    i = (i%10)
    --
    local bt_var = "xce.item." .. tostring(i) .. ".block_type"
    local cur_bt = ga_get_s(bt_var)
    local bt_is_solid = ga_bt_get_physically_solid(cur_bt)
    --
    i = (i%10)
    local tool_var = "xce.item." .. tostring(i) .. ".tool_name"
    local tool_name = ga_get_s(tool_var)
    if tool_name == "clear" then
        if bt_is_solid then
            return "xce_icon_block_gun_clear_solid"
        else
            return "xce_icon_block_gun_clear_empty"
        end
    end
    if tool_name == "single_block" then
        if bt_is_solid then
            return "xce_icon_block_gun_solid"
        else
            return "xce_icon_block_gun_empty" 
        end
    end
    if tool_name == "block_line" then
        if bt_is_solid then
            return "xce_icon_block_gun_solid_line"
        else
            return "xce_icon_block_gun_empty_line" 
        end
    end
    if tool_name == "paintcan" then
        return "xce_icon_block_gun_paintcan"
    end
    if tool_name == "paintcan_xy" then
        return "xce_icon_block_gun_paintcan_xy"
    end
    return "" --Uh oh!
end

function p.get_cur_tool_name()
    local cur_wep = p.get_cur_wep()
    cur_wep = (cur_wep % 10)
    local var = "xce.item." .. tostring(cur_wep) .. ".tool_name"
    return ga_get_s(var)
end

--Supported names:
--  clear
--  single_block
--  block_line
--  paintcan
--  paintcan_xy
function p.set_cur_tool_name(name)
    local cur_wep = p.get_cur_wep()
    local var = "xce.item." .. tostring(cur_wep) .. ".tool_name"
    ga_set_s(var, name)
end

function p.get_cur_bt()
    local cur_wep = p.get_cur_wep()
    local var = "xce.item." .. tostring(cur_wep) .. ".block_type"
    return ga_get_s(var)
end

function p.set_cur_bt(bt_str)
    local cur_wep = p.get_cur_wep()
    local var = "xce.item." .. tostring(cur_wep) .. ".block_type"
    ga_set_s(var, bt_str)
end
