function p.fill(level, bp, new_bt)
    local xy_only = false
    p.fill_helper(level, bp, new_bt, xy_only)
end

function p.fill_xy(level, bp, new_bt)
    local xy_only = true
    p.fill_helper(level, bp, new_bt, xy_only)
end

function p.fill_helper(level, bp, new_bt, xy_only)
    -- ga_print("------------------------------------------")
    -- ga_print("game_xce_paintcan")

    local vcp = ga_bp_to_parent_vcp(bp)
    local start_lbp = ga_bp_to_lbp(bp)
    local start_lbph = std.lbp_to_lbph(start_lbp)
    local start_bt = ga_block_get(level, bp)
    local touched = {}
    local to_go = {}

    -- ga_print("Starting lbph = " .. tostring(start_lbph))

    --Initial start.
    to_go[start_lbph] = true
    touched[start_lbph] = true

    while true do
        local lbph2 = p.get_table_first_key(to_go)
        if lbph2 == nil then return end
        to_go[lbph2] = nil
        local lbp2 = std.lbph_to_lbp(lbph2)
        local bp2 = ga_lbp_to_bp(vcp, lbp2)
        --
        -- ga_print("Considering LBPH key: " .. tostring(lbph2))
        -- ga_print("Considering LBP key: " .. std.bp_to_str(lbp2))
        --
        --Making sure it is in the same chunk.
        -- local vcp2 = ga_bp_to_parent_vcp(bp2)
        -- if not std.bp_eq(vcp, vcp2) then
            -- goto loop_continue_1 --Lua does not have a continue statement.
        -- end
        --
        --Changing the block type.
        ga_block_change_perm(level, bp2, new_bt)
        --
        --Considering the adjacent blocks.
        for side = 0,5 do
            local bp3 = std.get_adj_bp(bp2, side)
            -- ga_print("Adj bp: " .. std.bp_to_str(bp3))
            --
            local vcp3 = ga_bp_to_parent_vcp(bp3)
            if not std.bp_eq(vcp, vcp3) then
                goto loop_continue_2
            end
            --
            local lbp3 = ga_bp_to_lbp(bp3)
            local lbph3 = std.lbp_to_lbph(lbp3)
            --
            --Making sure the adj bt is ok.
            local bt3 = ga_block_get(level, bp3)
            if start_bt ~= bt3 then
                goto loop_continue_2
            end
            -- --            
            if xy_only then
                if( side == std.SIDE_Z_POS or
                    side == std.SIDE_Z_NEG )
                then
                    goto loop_continue_2
                end
            end
            -- --
            -- --Making sure the adj pos has not been "touched" yet.
            -- ga_print("Seeing if touched " .. tostring(lbph3))
            if touched[lbph3] ~= nil then
                goto loop_continue_2
            end
            -- ga_print("Not yet! Touching " .. tostring(lbph3))
            touched[lbph3] = true
            -- --
            --Adding the adj bp to the to_do list.
            to_go[lbph3] = true
            --
            ::loop_continue_2::
        end

        ::loop_continue_1::
  end
end

function p.get_table_first_key(t)
    for k,_ in pairs(t) do
        return k
    end
    return nil
end
