local initialized = false
local allowed_kinds = {}

function p.init_maybe()
    if( initialized ) then return end
    initialized = true
    allowed_kinds["forward"] = true
    allowed_kinds["back"] = true
    allowed_kinds["left"] = true
    allowed_kinds["right"] = true
    allowed_kinds["up"] = true
    allowed_kinds["down"] = true
    allowed_kinds["brake"] = true
    allowed_kinds["speed"] = true
end

function p.input(str)
    ga_debug_push("game_movement.input")
    p.input_meat(str)
    ga_debug_pop("game_movement.input")
end

function p.input_meat(str)
    p.init_maybe()
    --
    local strs = game_str.split(str)
    --strs[1] should be "move".
    local kind = strs[2] --Could be "forward" or "bake", etc.
    local action = strs[3] --Can be "start", "stop", or "toggle".
    if( allowed_kinds[kind] ~= true ) then return end
    --Exception kinds (oddballs).
    if( kind == "speed" ) then
        if( action == "increase" ) then p.increase_speed() end
        if( action == "decrease" ) then p.decrease_speed() end
    end
    --
    --Common kinds.
    local var = "var.movement." .. kind
    if      ( action == "start"     ) then ga_set_b(var, true)
    elseif  ( action == "stop"      ) then ga_set_b(var, false)
    elseif  ( action == "toggle"    ) then ga_toggle_b(var)
    else
    end
end

function p.speed_change_factor() return 1.5 end

function p.increase_speed()
    local speed = ga_get_f("var.movement.speed_factor")
    local factor = p.speed_change_factor()
    speed = speed * factor
    ga_set_f("var.movement.speed_factor", speed)
end

function p.decrease_speed()
    local speed = ga_get_f("var.movement.speed_factor")
    local factor = p.speed_change_factor()
    speed = speed / factor
    ga_set_f("var.movement.speed_factor", speed)
end

function p.update_discrete()
    --Translation movement.
    local lpd = ga_get_sys_v("game.player.move.last_pos_diff")
    local time_step = 0.04
    local speed = std.length(lpd) / time_step

    --Setting drag and magnitude of acceleration.
    local drag = 0.90
    local m_acc = 0.4

    if ga_get_b("var.movement.brake") then
        drag = 0.5
    end

    --Getting the acc due the pressing keys.
    local vec_look = ga_get_sys_v("game.player.camera.look")
    local vec_up   = ga_get_sys_v("game.player.camera.up")
    local vec_left = ga_get_sys_v("game.player.camera.left")

    local acc = std.vec_zero()
    if ga_get_b("var.movement.forward") then
        std.vec_add_eq(acc, vec_look)
    end
    if ga_get_b("var.movement.back") then
        std.vec_sub_eq(acc, vec_look)
    end
    if ga_get_b("var.movement.left") then
        std.vec_add_eq(acc, vec_left)
    end
    if ga_get_b("var.movement.right") then
        std.vec_sub_eq(acc, vec_left)
    end
    if ga_get_b("var.movement.up") then
        std.vec_add_eq(acc, vec_up)
    end
    if ga_get_b("var.movement.down") then
        std.vec_sub_eq(acc, vec_up)
    end

    --Normalizing acc vector.
    if ( std.length(acc) < 0.0001 ) then
        acc = std.vec_zero()
    else
        std.normalize(acc)
    end

    local speed_mod = 0.15 * ga_get_f("var.movement.speed_factor")
    std.vec_scale_eq(acc, m_acc)
    std.vec_scale_eq(acc, speed_mod)

    --Scaled lpd.
    local slpd = std.vec_scale(lpd, drag)

    --Setting the travel.
    local travel = std.vec_add(slpd, acc)
    ga_move_set_desired_travel(travel)
end
