function p.start_use(gun, primary)
    ga_set_i("xce.item.cur_item", gun)
    ga_set_b("xce.item.shooting_primary", primary)
    ga_set_b("xce.item.starting_shoot", true)
end

function p.end_use()
    ga_set_b("xce.item.starting_shoot", false)
end

function p.update()
    if ga_get_b("xce.item.starting_shoot") then
        p.try_shoot()
        p.end_use()
    end
end

function p.try_shoot()
    local cur_wep = ga_get_i("xce.item.cur_item")
    local primary = ga_get_b("xce.item.shooting_primary")
    local grab_mode = ga_get_b("xce.item.block_grab_mode")
    local cur_tool = game_xce_tool_helpers.get_cur_tool_name()

    if( grab_mode ) then
        local ment_type = (primary and
            "ment_grab_gun_inplace" or
            "ment_grab_gun_extrude")
        p.launch_particle(ment_type)
        return
    end
    if( cur_tool == "clear" ) then
        local ment_type = (primary and
            "ment_block_gun_clear_inplace" or
            "ment_block_gun_clear_extrude")
        p.launch_particle(ment_type)
        return
    end
    if( cur_tool == "single_block" ) then
        local ment_type = (primary and
            "ment_block_gun_single_inplace" or
            "ment_block_gun_single_extrude")
        p.launch_particle(ment_type)
        return
    end
    if( cur_tool == "block_line" ) then
        local ment_type = (primary and
            "ment_block_gun_line_inplace" or
            "ment_block_gun_line_extrude")
        p.launch_particle(ment_type)
        return
    end
    if cur_tool == "paintcan" then
        local ment_type = (primary and
            "ment_block_gun_paintcan_inplace" or
            "ment_block_gun_paintcan_extrude")
        p.launch_particle(ment_type)
        return
    end
    if cur_tool == "paintcan_xy" then
        local ment_type = (primary and
            "ment_block_gun_paintcan_xy_inplace" or
            "ment_block_gun_paintcan_xy_extrude")
        p.launch_particle(ment_type)
        return
    end
end

function p.launch_particle(ment_type)
    local extend_len = 0.1
    p.launch_particle2(ment_type, extend_len)
end

function p.launch_particle2(ment_type, extend_len)
    local viewer_chunk_id = ga_get_viewer_chunk_id()
    local viewer_level = ga_chunk_id_to_level(viewer_chunk_id)
    local viewer_pos = ga_get_viewer_offset()
    local look = ga_get_sys_v("game.player.camera.look")
    local pos = std.vec_add(viewer_pos, std.vec_scale(look, extend_len))
    local speed = 1000.0
    local vel = std.vec_scale(look, speed)
    ga_ment_start(viewer_level, pos, ment_type)
    ga_ment_init_set_v("__vel", vel)
    ga_ment_end()
    return
end
