--bp1 is the position of the block.
function p.can_build_block(level, bp1)
    return p.can_build_block_correct(level, bp1)
    -- return p.can_build_block_crude(level, bp1)
end

--The correct version.
function p.can_build_block_correct(level, block_bp)
    local viewer_level = ga_get_viewer_level()
    if( level ~= viewer_level ) then
        --We are not making a fractal mining game
        --in this package, just an Easter egg.
        return
    end
    --Seeing if bounding box of player
    --intersects the block.
    --vp = position of the player's eye.
    local vp = ga_get_viewer_offset()
    local radius = 0.15    --Too much.
    local bot_to_eye = 1.0 --Too much.
    local eye_to_top = 0.5 --Too much.
    local bbox_min_v = std.vec(
        vp.x - radius,
        vp.y - radius,
        vp.z - bot_to_eye)
    local bbox_max_v = std.vec(
        vp.x + radius,
        vp.y + radius,
        vp.z + eye_to_top)
    local bbox_min_bp = std.lp_to_bp(bbox_min_v)
    local bbox_max_bp = std.lp_to_bp(bbox_max_v)
    for x = bbox_min_bp.x, bbox_max_bp.x do
    for y = bbox_min_bp.y, bbox_max_bp.y do
    for z = bbox_min_bp.z, bbox_max_bp.z do
        local player_part_bp = std.bp(x,y,z)
        local str1 = std.vec_to_str(player_part_bp)
        local str2 = std.vec_to_str(block_bp)
        if( std.bp_eq(block_bp, player_part_bp) ) then
            --The block intersects the bounding
            --box of the player.
            return false
        end
    end end end
    return true
end

--The crude version.
--This algorithm is too cautious,
--but it is easy to program.
function p.can_build_block_crude(level, bp1)
    local viewer_level = ga_get_viewer_level()
    if( level ~= viewer_level ) then
        --We are not making a fractal mining game
        --in this package, just an Easter egg.
        return
    end

    local bp2 = ga_get_viewer_bp(viewer_level)
    local dist = std.dist_linf(bp1, bp2)
    if dist <= 1 then
        return false
    end
    return true
end