--This is called by the engine when the game is loaded.
function p.__load_game()
    local cmd_name = "use_equipped"
    game_command_system.add_command(cmd_name, p.handler)
    game_command_system.add_help(cmd_name, p.get_help_str())
end

function p.handler(str)
    local strs = game_str.split(str)
    if( #strs ~= 2 ) then return end --Uh oh!
    local str1 = strs[1]
    local str2 = strs[2]
    if( str2 == "start" ) then
        local cur_wep = game_xce_tool_helpers.get_cur_wep()
        --
        local primary = true
        if( str1 == "primary"       ) then primary = true
        elseif( str1 == "secondary" ) then primary = false
        else
            ga_print("Bad argument passed to use_equipped command: " .. str1)
            return
        end
        --
        game_xce_inv_exec.start_use(cur_wep, primary)
        return
    end
    if( str2 == "stop" ) then
        game_xce_inv_exec.end_use()
        return
    end
end

function p.get_help_str()
    return
           "Usage: use_equipped (primary | secondary) (start | stop)\n\n"
        .. "Uses the equipped item in the player's inventory. "
end
