--This is called by the engine when the game is loaded.
function p.__load_game()
    local cmd_name = "snap"
    game_command_system.add_command(cmd_name, p.handler)
    game_command_system.add_help(cmd_name, p.get_help_str())
end

function p.handler(str)
    local fn = "chunk_snapshot.lua"
    local full_fn = "Output/FileOut/" .. fn
    ga_console_print("Writing snapshot of current chunk to the following file: ")
    ga_console_print(full_fn)
    --h is the file "handle".
    local h = ga_open_file_for_writing(fn);
    local level = ga_get_viewer_level()
    local chunk_id = ga_get_viewer_chunk_id()
    local vcp = ga_chunk_id_to_vcp(chunk_id)
    local default_bt = ga_get_most_common_bt_in_chunk(chunk_id)
    p.line(h, "function p.__get_is_solid() return false end")
    p.line(h, "function p.__get_tex() return \"\" end")
    p.line(h, "")
    p.line(h, "function p.__main()")
    p.line(h, "    set_default_block(\"" .. default_bt .. "\")")
    --New way.
    local box_data = {}
    game_merge_engine.init_boxes(boxes)
    for z = 0,15 do
    for x = 0,15 do
    for y = 0,15 do
        local lbp = std.bp(x,y,z)
        local bp = std.lbp_to_bp(vcp, lbp)
        local bt = ga_block_get(level, bp)
        if bt ~= default_bt then
            if bt == "block_support" then
                --Will not add anything.
            elseif( p.is_bt_placeholder(bt) ) then
                local replace_str = p.get_placeholder_replace(bt,x,y,z)
                p.line(h, "    " .. replace_str)
            else
                game_bt_merge_engine.add_cube(box_data, bp, bt)
            end
        end
    end end end
    for bt,_ in pairs(box_data) do
        for box,_ in pairs(box_data[bt]) do
            local vol = game_merge_engine.get_box_volume(box)
            if vol == 1 then
                local bp = box.min
                p.line(h, "    set_pos("
                    .. tostring(bp.x) .. ","
                    .. tostring(bp.y) .. ","
                    .. tostring(bp.z) .. ", "
                    .. "\"" .. bt .. "\")")
            else
                p.line(h, "    create_rect(\"" .. bt .. "\", "
                    .. tostring(box.min.x) .. ","
                    .. tostring(box.min.y) .. ","
                    .. tostring(box.min.z) .. ", "
                    .. tostring(box.max.x) .. ","
                    .. tostring(box.max.y) .. ","
                    .. tostring(box.max.z) .. ")")
            end
        end
    end
    --Old way.
    -- for z = 0,15 do
    -- for x = 0,15 do
    -- for y = 0,15 do
    --     local lbp = std.bp(x,y,z)
    --     local bp = std.lbp_to_bp(vcp, lbp)
    --     local bt = ga_block_get(level, bp)
    --     if bt ~= default_bt then
    --         p.line("    set_pos(" .. tostring(x) .. "," .. tostring(y) .. "," .. tostring(z) .. ", \"" .. bt .. "\")")
    --     end
    -- end end end
    --.
    p.line(h, "end")
    ga_close_file(h);
    return false
end

function p.line(handle, str)
    -- ga_print(str)
    ga_write(handle, str .. "\n")
end

function p.is_bt_placeholder(bt)
    return bt:find("^block_placeholder")
end

function p.get_placeholder_replace(bt,x,y,z)
    local mod_name = bt
    local func_name = "placeholder_for"
    if( _G[mod_name] and
        _G[mod_name][func_name] )
    then
        --Calling the function in the block lua script.
        return _G[mod_name][func_name](x,y,z)
    end
    return "" --Uh oh!
end

function p.get_help_str()
    return
           "Usage: snap\n\n"
        .. "When you run this command, the chunk you are in will be used to "
        .. "auto genereate the Lua code for a block script. "
end
