--This is called by the engine when the game is loaded.
function p.__load_game()
    local cmd_name = "open_xce_window"
    game_command_system.add_command(cmd_name, p.handler)
    game_command_system.add_help(cmd_name, p.get_help_str())
end

function p.handler(str)
    --We are assuming game and main_menu window stacks are empty.
    --So the player is playing the game normally and unpaused.
    --Indeed, this is the only time that input binds are executed.
    --Could verify the game is unpaused with ga_get_game_paused()
    local strs = game_str.split(str)
    if( #strs == 0 ) then return end --Uh oh!
    local str1 = strs[1]
    if( str1 == "tool_select") then
        ga_window_push("win_xce_tool_select")
    end
    --Could complain if bad args.
end

function p.get_help_str()
    return
           "Usage: open_window tool_select"
        .. "Opens the xce (xar chunk edit) tool selection window. "
end
