--Helper.
function p.txt_col(wid, col)
    ga_win_set_front_color(wid, col)
end

function p.interp_col(col1, col2, frac)
    local col = {x=0, y=0, z=0}
    col.x = (1.0 - frac)*col1.x + frac*col2.x
    col.y = (1.0 - frac)*col1.y + frac*col2.y
    col.z = (1.0 - frac)*col1.z + frac*col2.z
    return col
end

function p.draw_item(
    wid, num, item_y_min,
    item_height, item_x_delta, item_width,
    tex_name)
    local y_min = item_y_min
    local y_max = y_min + item_height

    local raw_num = num
    local x_min = 0.21 + item_x_delta * (raw_num-1)
    local x_max = x_min + item_width
    local cur_wep = ga_get_i("var.player.cur_wep")
    if ( (raw_num%10) == cur_wep) then
        local add = 0.02
        y_min = y_min + add
        y_max = y_max + add
    end
    ga_win_quad(wid, x_min, y_min, x_max, y_max, tex_name)
end

function p.__render(wid)
    --ga_win_set_background_default(wid, )
    ga_win_set_char_size(wid, 0.012, 0.024)

    local col_white  = std.vec(1.0, 1.0, 1.0)
    local col_red    = std.vec(1.0, 0.0, 0.0)
    local col_yellow = std.vec(1.0, 1.0, 0.0)
    local col_green  = std.vec(0.0, 1.0, 0.0)
    local col_blue   = std.vec(0.0, 0.25, 1.0)
    local col_cyan   = std.vec(0.0, 1.0, 1.0)

    local item_y_min = 0.01
    local item_width = 0.059
    local item_height = 0.086
    local item_x_delta = 0.065

    -- p.draw_item(wid, 1, item_y_min, item_height, item_x_delta, item_width, "block_gun")
    -- p.draw_item(wid, 2, item_y_min, item_height, item_x_delta, item_width, "ladder_gun");
    -- p.draw_item(wid, 3, item_y_min, item_height, item_x_delta, item_width, "note_gun");
    -- p.draw_item(wid, 4, item_y_min, item_height, item_x_delta, item_width, "block_diamond");
    -- p.draw_item(wid, 5, item_y_min, item_height, item_x_delta, item_width, "shrink_grow");

    -- Icons.
    local icon_bot = 0.13
    local icon_top = icon_bot + 0.08
    local icon_width = 0.05

    local step_x = icon_width + 0.01
    local cur_x = 0.01

    if ga_get_b("var.movement.ledge_guard") then
        tex = "ledge_guard"
        ga_win_quad(wid, cur_x, icon_bot, cur_x+icon_width, icon_top, tex)
        cur_x = cur_x + step_x
    end

    --Lower left message.
    -- if( not ga_get_b("var.hud.msg.disable_msgs") ) then
    if( true ) then
        ga_win_set_char_size(wid, 0.015, 0.03)
        p.txt_col(wid, col_green)
        for i = 1,5 do
            local prefix = "var.messages.slot" .. tostring(i)
            local msg = ga_get_s(prefix .. ".msg")
            local ttl = ga_get_f(prefix .. ".ttl") 
            --
            local col = col_white
            if ttl < 4.0 then col = col_green end
            if( ttl > 4.0 and ttl < 5.0 ) then
                col = p.interp_col(col_green,col_white,ttl-4.0)
            end
            p.txt_col(wid, col)
            --
            local min_x = 0.01
            local min_y = 0.25 + 0.033*(i-1)
            local alpha_fade = 1.0
            if( ttl < 1.0 and ttl >= 0.0 ) then alpha_fade = ttl end
            if ttl > 0.0 then
                local color = std.vec(0.0,0.0,0.0)
                local back_alpha = 0.4 * alpha_fade
                local front_alpha = 1.0 * alpha_fade
                ga_win_set_back_params(wid, color, back_alpha, back_alpha)
                ga_win_txt_alpha_bg(wid, min_x, min_y, front_alpha, msg)
            end
        end
    end
end
