function p.__load_game()
    ga_hud_window_add("win_hud", 0)
end

--This is called before the metachunk tree update,
--before the proximity update, and before the
--discrete updates (if there are any of those).
function p.__update()
end

function p.__update_passive()
    --Nothing to do.
end

function p.__update_discrete_pre()
    game_init_body.first_try()
end

function p.__update_discrete_post()
    game_movement.update_discrete()
end

function p.__game_input(str)
    if( str == "__game_saved__" ) then
        game_msg.add("Game saved")
        return ""
    end

    if( str:find("^__spiral_of_death__") ~= nil ) then
        --Could add a message using "game_msg.add".
        return ""
    end

    if( str == "__screenshot__" ) then
        game_msg.add("Screenshot saved")
        return ""
    end

    --Moving.
    if( str:find("^move") ~= nil ) then
        --str starts with "move".
        game_movement.input(str)
        return ""
    end

    if( str:find("^q2md2_cmd") ) then
        cmd = string.gsub(str ,"q2md2_cmd ", "")
        ga_print("running the q2md2 command: " .. cmd)
        ga_player_model_q2md2_set_cmd(cmd)
        return ""
    end

    if( str == "fly" ) then
        cur_mode = ga_get_sys_s("game.player.move.mode")
        if( cur_mode ~= "fly" ) then
            game_init_body.fly_try()
        end
        if( cur_mode ~= "ground" ) then
            game_init_body.ground_try()
        end
        return ""
    end
    if( str == "fly on" ) then
        cur_mode = ga_get_sys_s("game.player.move.mode")
        if( cur_mode ~= "fly" ) then
            game_init_body.fly_try()
        end
        return ""
    end
    if( str == "fly off" ) then
        cur_mode = ga_get_sys_s("game.player.move.mode")
        if( cur_mode ~= "ground" ) then
            game_init_body.ground_try()
        end
        return ""
    end

    ga_console_print("^1Error: unknown string passed to game_input: ")
    ga_console_print(str)
    return ""
end

function p.kill_player()
    --Nothing to do.
end

function p.__respawn_player()
    --Nothing to do.
end
