function p.update_discrete()
    --Translation movement.
    local lpd = ga_get_sys_v("game.player.move.last_pos_diff")
    local time_step = 0.04
    local speed = std.length(lpd) / time_step

    --Setting drag and magnitude of acceleration.
    local primary_speed_cutoff = 6.0 --Not being used!
    local drag = 0.90
    local m_acc = 0.4

    --Getting the acc due the pressing keys.

    local vec_look = ga_get_sys_v("game.player.camera.look")
    local vec_up   = ga_get_sys_v("game.player.camera.up")
    local vec_left = ga_get_sys_v("game.player.camera.left")

    acc = std.vec_zero()
    if ga_get_b("var.movement.forward") then
        std.vec_add_eq(acc, vec_look)
    end
    if ga_get_b("var.movement.back") then
        std.vec_sub_eq(acc, vec_look)
    end
    if ga_get_b("var.movement.left") then
        std.vec_add_eq(acc, vec_left)
    end
    if ga_get_b("var.movement.right") then
        std.vec_sub_eq(acc, vec_left)
    end
    if ga_get_b("var.movement.fly.up") then
        std.vec_add_eq(acc, vec_up)
    end
    if ga_get_b("var.movement.fly.down") then
        std.vec_sub_eq(acc, vec_up)
    end

    --Normalizing acc vector.
    if ( std.length(acc) < 0.0001 ) then
        acc = std.vec_zero()
    else
        std.normalize(acc)
    end

    local speed_mod = 0.15
    std.vec_scale_eq(acc, m_acc)
    std.vec_scale_eq(acc, speed_mod)

    --Scaled lpd.
    local slpd = std.vec_scale(lpd, drag)

    --Setting the travel.
    local travel = std.vec_add(slpd, acc)
    ga_move_set_desired_travel(travel)
end
