function p.__get_is_solid()return true end
function p.__get_tex() return "block_default" end

--Layer 1 terrain.
function p.__main()
    set_default_block("e")
    create_rect("block_perlin_3d_smooth_main", 0,0,0, 15,15,7)

    local msg_str = "Example 7:\n\n"
        .."This is 3D Perlin noise but when you shrink "
        .. "the surface is \"^x00ff00smooth^!\".\n\n"
        .. "This is accomplished by having three block types:\n\n"
        .. "block_perlin_3d_smooth_main,\n"
        .. "block_perlin_3d_solid,\n"
        .. "block_perlin_3d_empty.\n\n"
        .. "The \"main\" block type contains solid blocks of type "
        .. "block_perlin_3d_solid and empty blocks of type "
        .. "block_perlin_3d_empty. "
    h.txt(7,7,15, msg_str)

    local msg_str = "Note that there is a clever way to make this faster. "
        .. "The user can implement this idea if they want:\n\n"
        .. "^x00ff00The main block type should actually contain 4 types of blocks: "
        .. "solid boring, empty boring, block_perlin_3d_solid, and "
        .. "block_perlin_3d_empty.^!\n\n"
        .. "The non-boring block types are only used when we are close "
        .. "to the isosurface. "
    h.txt(7,7,13, msg_str)
end
