function p.__get_is_solid()return true end
function p.__get_tex() return "block_default" end

--vc_data = virtual chunk data.
--pd = perlin data.
--x_frac, y_fract = fractions for local chunk.
function p.height_frac_local(index, vc_data, pd, x_frac, y_frac)
    local xf = pd.rmin.x * (1.0 - x_frac) + pd.rmax.x * x_frac
    local yf = pd.rmin.y * (1.0 - y_frac) + pd.rmax.y * y_frac
    local value = perlin_noise_xy(index, xf, yf)
    local height_frac_global = value + 0.5
    local height_frac_local =
        (height_frac_global - vc_data.rmin.z) /
        (vc_data.rmax.z - vc_data.rmin.z)
    return height_frac_local
end

--Layer 2 terrain.
function p.__main()
    set_default_block("e")
    local chop = 4
    local salt = 0
    local d1 = chunk_bbox_to_vchunk(chop)
    local d2 = get_perlin_data_xy(chop, salt)
    local index = 1 --Could be any integer.
    cache_perlin_data_xy(index, d2.seeds)
    local iw = 1.0 / 16.0 --Inverse chunk width.
    for x = 0,15 do
    for y = 0,15 do
        local x_frac = x * iw
        local y_frac = y * iw
        local value1 = p.height_frac_local(
            index, d1, d2, x_frac, y_frac)
        local height_int = math.floor(value1 * 16)
        if height_int >= 0 then
            if height_int >= 15 then height_int = 15 end
            create_rect("s", x,y,0, x,y,height_int)
        end
    end end
end
