function p.__get_is_solid()return true end
function p.__get_tex() return "block_default" end

function p.__main()
    set_default_block("e")
    create_rect("s", 0,0,0, 15,15,6)
    create_rect("block_perlin_2d_large2", 0,0,4, 15,15,7)

    local msg_str = "Example 2:\n\n"
        .. "This is 2D Perlin noise "
        .. "but the corners are from a 4x4x4 chunk region.\n\n"
        .. "Probably the hardest concept involved in these "
        .. "Perlin noise examples is the \"^x00ff00virtual chunk^!\".\n\n"
        .. "You specify the \"virtual chunk\" by specifying an integer "
        .. "\"chop\" value.  A chop value of 0 will make the virtual chunk "
        .. "be the same as the chunk being generated.\n\n"
        .. "However using a chop value of 1 will set the \"virtual chunk\" "
        .. "to be a region of 2x2x2 chunks which contains the chunk being "
        .. "generated.\n\n"
        .. "Using a chop value of 2 will set the virtual chunk to be a region "
        .. "of 4x4x4 chunks which contains the chunk being generated, etc. "
        .. "The virtual chunk width goes up by powers of 2. "
    h.txt(7,7,15, msg_str)

    local msg_str = "We call ^x00ff00vchunk_data = chunk_bbox_to_vchunk(chop)^! "
        .. "to get basic information about the virtual chunk, "
        .. "and the relationship between the chunk being generated "
        .. "and the virtual chunk.\n\n"
        .. "The vector vchunk_data.rmin is the min (left/back/bottom) position "
        .. "of the chunk being generated in the coordinate system of the "
        .. "virtual chunk.\n\n"
        .. "For example, vchunk_data.rmin.x will be between 0.0 and 1.0 inclusive.\n\n"
        .. "On the other hand, vchunk_data.rmax is the max position "
        .. "of the chunk being generated in the coordinate system of the "
        .. "virtual chunk. " 
    h.txt(7,7,13, msg_str)
end
