function p.__get_is_solid()return true end
function p.__get_tex() return "block_default" end

-------------------------------------------------------------------------

--Very tall terrain (xy with vchunk).
function p.__main()
    set_default_block("e")
    local salt = 0
    local vchunk_data = chunk_bbox_to_vchunk(2)
    --
    local d1 = get_perlin_data_xy(0, salt)
    local d2 = get_perlin_data_xy(1, salt)
    local d3 = get_perlin_data_xy(2, salt)
    --
    local index1 = 1
    local index2 = 2
    local index3 = 3
    cache_perlin_data_xy(index1, d1.seeds)
    cache_perlin_data_xy(index2, d2.seeds)
    cache_perlin_data_xy(index3, d3.seeds)
    --
    local iw = 1.0 / 16.0
    for x = 0,15 do
    for y = 0,15 do
        local x_frac = x * iw
        local y_frac = y * iw
        --
        local xf = d1.rmin.x * (1.0 - x_frac) + d1.rmax.x * x_frac
        local yf = d1.rmin.y * (1.0 - y_frac) + d1.rmax.y * y_frac
        local value1 = perlin_noise_xy(index1, xf, yf)
        --
        local xf = d2.rmin.x * (1.0 - x_frac) + d2.rmax.x * x_frac
        local yf = d2.rmin.y * (1.0 - y_frac) + d2.rmax.y * y_frac
        local value2 = perlin_noise_xy(index2, xf, yf)
        --
        local xf = d3.rmin.x * (1.0 - x_frac) + d3.rmax.x * x_frac
        local yf = d3.rmin.y * (1.0 - y_frac) + d3.rmax.y * y_frac
        local value3 = perlin_noise_xy(index3, xf, yf)
        --
        local height_global = 0.5 + 0.5*(0.5*value1 + 1.0*value2 + 2.0*value3)
        local height_local = (height_global - vchunk_data.rmin.z) / (vchunk_data.rmax.z - vchunk_data.rmin.z)
        local height_int = math.floor(height_local * 16)
        if height_int >= 0 then
            if height_int >= 15 then height_int = 15 end
            create_rect("s", x,y,0, x,y,height_int)
        end
    end end
end
